/*==============================================================*/
/* Database name:  BASE_DE_DATOS_CLIENTE_FISICO                 */
/* DBMS name:      MySQL 3.23                                   */
/* Created on:     07-05-2005 18:16:22                          */
/*==============================================================*/


drop index RELATIONSHIP_1_FK on CLIENTE;

drop index RELATIONSHIP_2_FK on CLIENTE;

drop index RELATIONSHIP_3_FK on COMUNA;

drop table if exists CLIENTE;

drop table if exists COMUNA;

drop table if exists REGION;

drop table if exists SEXO;

/*==============================================================*/
/* Table: CLIENTE                                               */
/*==============================================================*/
create table if not exists CLIENTE
(
   RUT                            varchar(10)                    not null,
   ID_SEXO                        int                            not null,
   ID_COMUNA                      int                            not null,
   NOMBRE                         varchar(50)                    not null,
   APE_PAT                        varchar(50)                    not null,
   APE_MAT                        varchar(50),
   FE_NAC                         date                           not null,
   DIRECCION                      varchar(50),
   T_FIJO                         varchar(7)                     not null,
   T_MOVIL                        varchar(7),
   PASS                           varchar(8)                     not null,
   primary key (RUT)
);

/*==============================================================*/
/* Index: RELATIONSHIP_1_FK                                     */
/*==============================================================*/
create index RELATIONSHIP_1_FK on CLIENTE
(
   ID_SEXO
);

/*==============================================================*/
/* Index: RELATIONSHIP_2_FK                                     */
/*==============================================================*/
create index RELATIONSHIP_2_FK on CLIENTE
(
   ID_COMUNA
);

/*==============================================================*/
/* Table: COMUNA                                                */
/*==============================================================*/
create table if not exists COMUNA
(
   ID_COMUNA                      int                            not null AUTO_INCREMENT,
   ID_REGION                      int                            not null,
   NOMBRE_COMUNA                  varchar(50)                    not null,
   primary key (ID_COMUNA)
);

/*==============================================================*/
/* Index: RELATIONSHIP_3_FK                                     */
/*==============================================================*/
create index RELATIONSHIP_3_FK on COMUNA
(
   ID_REGION
);

/*==============================================================*/
/* Table: REGION                                                */
/*==============================================================*/
create table if not exists REGION
(
   ID_REGION                      int                            not null AUTO_INCREMENT,
   NOMBRE_REGION                  varchar(50)                    not null,
   primary key (ID_REGION)
);

/*==============================================================*/
/* Table: SEXO                                                  */
/*==============================================================*/
create table if not exists SEXO
(
   ID_SEXO                        int                            not null AUTO_INCREMENT,
   TIPO_SEXO                      varchar(20)                    not null,
   primary key (ID_SEXO)
);

